package com.androidbook.myfirstandroidapp;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.media.MediaPlayer;
import android.net.Uri;
import android.location.Location;
import android.location.LocationManager;


public class MyFirstAndroidAppActivity extends Activity {
	
	private static final String DEBUG_TAG= "MyFirstAppLogging";
	private MediaPlayer mp;
	
    /** Wywoływana w momencie pierwszego uruchamiania aktywności. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        Log.i(DEBUG_TAG, "Informacja o aplikacji MyFirstAndroidApp.");
        
        getLocation(); 
        
        // playMusicFromWeb();
        
        //forceError();
    }
    public void forceError() {
        if(true) {
            throw new Error("O rany!");
        }
    }
    
	public void playMusicFromWeb() {
	    try {
	        Uri file = Uri.parse("http://www.perlgurl.org/podcast/archives/podcasts/PerlgurlPromo.mp3");
	        mp = MediaPlayer.create(this, file);
	        mp.start();
	    }
	    catch (Exception e) {
	        Log.e(DEBUG_TAG, "Błąd odtwarzacza", e);
	    }
	}
    
    public void getLocation() {
        try {
            LocationManager locMgr = (LocationManager)
                getSystemService(LOCATION_SERVICE);
            Location recentLoc = locMgr.  
                getLastKnownLocation(LocationManager.GPS_PROVIDER); 
            Log.i(DEBUG_TAG, "lokalizacja: " + recentLoc.toString());
        }
        catch (Exception e) {
            Log.e(DEBUG_TAG, "Nie udało się określić położenia", e);
        }
    }

    
    protected void onStop() {
        if (mp != null) {
            mp.stop();
            mp.release();
        }
        super.onStop();
    }



}